(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      5807,        172]
NotebookOptionsPosition[      5389,        156]
NotebookOutlinePosition[      5843,        174]
CellTagsIndexPosition[      5800,        171]
WindowTitle->Potassium ViscoDiff EoS
WindowFrame->Palette*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       StyleBox[
       "\"EOSPotassium guide\"", 12, FontFamily -> "Times", StripOnInput -> 
        False], "paclet:EOSPotassium/guide/EOSPotassium", 
       "paclet:EOSPotassium/guide/EOSPotassium", "Link", {"HyperlinkActive"}, 
       BaseStyle -> {FontColor -> GrayLevel[0]}, Appearance -> "Palette", 
       ImageSize -> 180},
      "HyperlinkTemplate"]},
    {
     TemplateBox[{
       StyleBox[
       "\"Potassium Function Listing\"", 12, FontFamily -> "Times", 
        StripOnInput -> False], 
       "paclet:EOSPotassium/ref/EOSPotassiumFunctions", 
       "paclet:EOSPotassium/ref/EOSPotassiumFunctions", "Link", {
       "HyperlinkActive"}, BaseStyle -> {FontColor -> GrayLevel[0]}, 
       Appearance -> "Palette", ImageSize -> 180},
      "HyperlinkTemplate"]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{"\[Eta]", " ", "in", " ", "gaseous", " ", "phase"}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"etaKVap", "[", 
         RowBox[{
           
           TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity", 
            SyntaxForm -> Mod], ",", 
           TemplateBox[{"\[Rho]", 
             
             RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
               "\[InvisibleSpace]", 
               SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
             FractionBox["\"Grams\"", 
              SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
            SyntaxForm -> Mod]}], "]"}],
      ImageSize->180]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{
        StyleBox[
         SubscriptBox["D", "t"],
         FontSlant->"Italic"], 
        StyleBox[" ",
         FontSlant->"Italic"], "in", " ", "gaseous", " ", "phase"}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"DtKVap", "[", 
         RowBox[{
           
           TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity", 
            SyntaxForm -> Mod], ",", 
           TemplateBox[{"\[Rho]", 
             
             RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
               "\[InvisibleSpace]", 
               SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
             FractionBox["\"Grams\"", 
              SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
            SyntaxForm -> Mod]}], "]"}],
      ImageSize->180]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{"<", " ", 
        SuperscriptBox["u", "2"], " ", ">", " ", 
        RowBox[{"in", " ", "gaseous", " ", "phase"}]}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"u2lVap", "[", 
         RowBox[{
           
           TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity", 
            SyntaxForm -> Mod], ",", 
           TemplateBox[{"\[Rho]", 
             
             RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
               "\[InvisibleSpace]", 
               SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
             FractionBox["\"Grams\"", 
              SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
            SyntaxForm -> Mod]}], "]"}],
      ImageSize->180]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{
       "\[Eta]", " ", "1", "atm", " ", "in", " ", "liquid", " ", "phase"}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"etaK1atm", "[", 
         TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity", 
          SyntaxForm -> Mod], "]"}],
      ImageSize->180]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{
        StyleBox[
         SubscriptBox["D", "t"],
         FontSlant->"Italic"], " ", "1", "atm", " ", "in", " ", "liquid", " ",
         "phase"}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"DtK1atm", "[", 
         TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity", 
          SyntaxForm -> Mod], "]"}],
      ImageSize->180]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Center}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0.1}}}],
  "Column"]],ExpressionUUID->"2e72a2a2-16ed-4356-9464-6da60132fa8c"]
},
WindowSize->All,
WindowMargins->{{Automatic, 774}, {Automatic, 113}},
WindowElements->{},
WindowTitle->"Potassium ViscoDiff EoS",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->"Palette.nb",
ExpressionUUID->"62b88131-11ae-4d3a-bf42-761775ae7025"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[596, 21, 4789, 133, 148, InheritFromParent,ExpressionUUID->"2e72a2a2-16ed-4356-9464-6da60132fa8c"]
}
]
*)

(* End of internal cache information *)

